/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF CardFilter sample using ATR.
 *
 */

package scfbundle;

import java.util.Enumeration;
import java.util.Hashtable;

import jp.co.ricoh.dsdk.scard.framework.card.CardFilter;
import jp.co.ricoh.dsdk.scard.framework.card.Card.Info;

/**
 * AtrFilter class
 * This class performs card filterng using ATR and ATR mask.
 * 
 * AtrFilterクラス
 * ATRとビットマスクを使用して、カードフィルタリングします。
 * 
 */
class AtrFilter implements CardFilter{
	
	/**
	 * The HashTable which stores card ATR masks and corresponding card ATRs as key/value pairs.
	 * 
	 * ビットマスクがキーで、ATRが値のハッシュテーブル。
	 */
	private Hashtable hashTable = new Hashtable();
	
	/**
	 * Constructs a new AtrFilter object.
	 * 
	 * AtrFilterオブジェクトを構築します。
	 */
	public AtrFilter(){}
	
	/**
	 * Puts a card ATR mask and a card ATR to the hashtable as a key/value pair.
	 * 
	 * ビットマスクとATRをセットします。
	 */
	public void put(byte[] mask, byte[] atr){
		hashTable.put(mask, atr);
	}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.framework.card.CardFilter#isCandidate(jp.co.ricoh.dsdk.scard.framework.card.Card.Info)
	 */
	public boolean isCandidate(Info info) {
		boolean ret = false;
		
		if (info == null) return ret;
		
		try {
			/*
			 * obtains ATR of the card
			 * カードのATR取得
			 */
			byte[] card = info.getAtr();
			
			byte masked = 0; 
			
			/*
			 * looks for a matching ATR
			 * ATR検索
			 */
			Enumeration em = hashTable.keys();
			while (em.hasMoreElements() && !ret) {
				byte[] mask = (byte[]) em.nextElement();
				byte[] atr = (byte[]) hashTable.get(mask);
				
				if (atr.length == card.length) {
					int i = 0;
					for (; i < atr.length; i++) {
						/*
						 * masks ATR
						 * マスクする
						 */
						masked = (byte)(card[i] & mask[i]);
						/*
						 * compares ATR
						 * 比較する
						 */
						if(masked!=atr[i]){
							break;
						}
					}
					if(!(i < card.length)){
						ret = true;
					}
				}
			}
			
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return ret;
	}
}